# GeoCrsTransform.MinimalApiSample

A minimal ASP.NET Core API demonstrating the use of the GeoCrsTransform library for coordinate reference system (CRS) transformations.

## Endpoints

### POST /transform
Transform coordinates between CRSs.

**Request Example:**
```
POST /transform
Content-Type: application/json
{
  "lat": 51.5074,
  "lon": -0.1278,
  "from": "WGS84",
  "to": "OSGB36"
}
```

**Response Example:**
```
{
  "easting": 530000,
  "northing": 180000,
  "crs": "OSGB36"
}
```

### GET /crs
List supported CRSs.

**Response Example:**
```
[
  { "id": "WGS84", "name": "World Geodetic System 1984" },
  { "id": "OSGB36", "name": "Ordnance Survey Great Britain 1936" }
]
```

## Swagger UI
Run the project and navigate to `/swagger` for interactive API documentation and testing.

## Running the Project
```
dotnet run --project GeoCrsTransform.MinimalApiSample
```

---

This project is intended as a minimal, zippable sample for blog/demo purposes.
